/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.mixin;

import com.starfish_studios.naturalist.NaturalistConfig;
import com.starfish_studios.naturalist.common.entity.Firefly;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.logging.Logger;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1308.class})
public abstract class MobMixin
extends class_1309 {
    @Unique
    private static final Logger naturalist$LOGGER = Logger.getLogger("Naturalist");

    protected MobMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD")})
    private void naturalist$onDoHurtTarget(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        if (class_7923.field_41177.method_10221((Object)this.method_5864()).equals((Object)class_7923.field_41177.method_10221((Object)class_1299.field_37419)) && entity instanceof Firefly) {
            this.method_6092(new class_1293(class_1294.field_5912, 60));
        }
    }

    @Inject(method={"checkDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void naturalist$checkDespawnMixin(CallbackInfo ci) {
        if (!this.method_5864().method_20210(NaturalistTags.EntityTypes.NATURALIST_ENTITIES)) {
            return;
        }
        if (class_7923.field_41177.method_10221((Object)this.method_5864()).method_12832().equals("caterpillar")) {
            return;
        }
        String mobName = this.naturalist$toCamelCase(class_7923.field_41177.method_10221((Object)this.method_5864()).method_12832());
        String configFieldName = mobName + "Removed";
        try {
            boolean animalRemoved = NaturalistConfig.class.getField(configFieldName).getBoolean(null);
            if (animalRemoved) {
                this.method_5650(class_1297.class_5529.field_26999);
                ci.cancel();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Failed to check despawn config for mob '" + mobName + "': " + configFieldName);
            e.printStackTrace();
        }
    }

    @Unique
    private String naturalist$toCamelCase(String input) {
        StringBuilder camelCase = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : input.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            camelCase.append(capitalizeNext ? Character.toUpperCase(c) : c);
            capitalizeNext = false;
        }
        return camelCase.toString();
    }
}

